class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Iron Man Magazine'
    oldest_article = 21
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='div', attrs={'class':'postarea'})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['date','adsense-post']}),
                   dict(name='div', attrs={'id':['subnavbar','sidebar','footer','success-stories','fb-root']}),
                   dict(name='img'),]

    feeds          = [(u'Training', u'http://www.ironmanmagazine.com/site/feed/?cat=14'), 
                          (u'Nutrition', u'http://www.ironmanmagazine.com/site/feed/?cat=15')
]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup